
## ⚡ TL;DR (快速開始)

```bash
# 1. 解壓並進入目錄
tar -xzvf db_tools.tar.gz && cd db_tools

# 2. 給予執行權限
chmod +x *.sh

# 3. 匯出 (從舊 DB 抓結構)
./export_ddl.sh

# 4. 匯入 (還原到新 DB)
./import_auto.sh
```

***

## 📖 詳細說明

### 1. 匯出腳本 `export_ddl.sh`
**功能**：從來源資料庫匯出純結構 SQL 檔。
- **自動清理**：移除 `AUTO_INCREMENT=n` (重置 ID 計數)。
- **相容性處理**：移除 `CHARSET` 與 `COLLATE` 定義，避免鎖死編碼。
- **完整結構**：保留 Table Partition (分區) 定義。
- **設定方式**：編輯腳本內的 `DATABASES=(...)` 列表來指定要備份的資料庫。
```bash
DATABASES=(
    "dev_smartfds_sso"
    "dev_new_database"  <-- 腳本會自動移除 dev_開頭
)
```


### 2. 匯入腳本 `import_auto.sh`
**功能**：掃描目錄下的 `.sql` 檔並批次匯入。
- **自動對應**：檔名即庫名 (例：`app_data.sql` ➝ 建立 `app_data` DB)。
- **強制編碼**：建立 DB 時強制指定 `CHARACTER SET utf8`。
  > ⚠️ **注意**：這是為了防止 MySQL 8.0 預設 `utf8mb4` 導致 `VARCHAR(255)` 索引長度爆表 (`Key too long`) 的保護機制。

### 📋 系統需求
- Linux / macOS 環境
- 已安裝 `mysql` 與 `mysqldump` 指令
- 來源與目標資料庫的連線權限 (Host/User/Password)